/*
window.onerror = function() {
	alert(JSON.stringify(arguments));
};
*/
(function(externalVars) {
	// WIN7/XP使用不同的字体
	document.documentElement.classList.add(/(Windows) (NT) (\d+\.\d+)/.exec(navigator.userAgent)[3] > 5 ? 'win7' : 'xp');
	
	document.addEventListener('DOMContentLoaded', function() {
		var close = document.getElementById('close'),
			main = document.getElementById('main'),
			icon = document.getElementById('icon'),
			title = document.getElementById('title'),
			content = document.getElementById('content'),
			action = document.getElementById('action'),
			actionButton = document.getElementById('action-button'),
			show = function(element) {
				/*element.style.display = 'block';*/
				element.classList.add('show');
			};

		// 根据传入“通知”页面的数据，动态构造“通知”的View
		for (var field in externalVars) {
			switch (field) {
				// 图标(optional)
				case 'icon':
					icon.style.background = ['url(', externalVars[field], ') no-repeat'].join('');
					show(icon);
					break;
				
				// 标题(optional)
				case 'title':
					title.innerText = externalVars[field];
					show(title);
					break;
				
				// 内容
				case 'content':
					content.innerHTML = externalVars[field];
					break;
				
				// 动作(optional)
				case 'action':
					show(action);
					externalVars[field].forEach(function(item, index) {
						if (item.type === 'button') {
							var button = document.createElement('input');
							button.type = 'button';
							button.value = item.value;
							if (item.autofocus) {
								button.autofocus = '';
							}
							if (item.css) {
								for (var cssProperty in item.css) {
									button.style[cssProperty] = unescape(item.css[cssProperty]);
								}
							}
							button.addEventListener('click', function() {
								new Function(unescape(item.event)).call();
							}, false);
							action.appendChild(button);
						} else if (item.type === 'link') {
							var link = document.createElement('div');
							link.innerText = item.value;
							link.addEventListener('click', function() {
								new Function(unescape(item.event)).call();
							}, false);
							action.appendChild(link);
						}
					});
					break;
				
				case 'closeAdditionalEvent':
					close.addEventListener('click', function() {
						// 不能用 externalVars[field]
						new Function(unescape(externalVars['closeAdditionalEvent'])).call();
					}, false);
					break;
				
				default:
			}
		}
		
		// 点击“关闭按钮”，销毁当前“通知”
		// 这个绑定必须在后面，因为 closeAdditionalEvent 指定的事件需要在销毁之前执行
		close.addEventListener('click', function() {
			qqbrowser.tip.destroyMe();
		}, false);

		// 显示“通知”
		var clientRect = document.body.getBoundingClientRect();
		qqbrowser.extension.page.show({width: clientRect.width, height: clientRect.height});
	}, false);
})(qqbrowser.extension.page.initData);